#include <QtGui>

 #include "DirectQueryDlg.h"
 #include "IntroModeSelectDlg.h"
 #include "MainTextEdit.h"
 #include "ConnectionForm.h"
 #include "MainForm.h"
 #include "TextEdit.h"
 #include "Highlighter.h"

 #define MESSAGE \
     DirectQueryDlg::tr("<p>Message boxes have a caption, a text, " \
                "and any number of buttons, each with standard or custom texts." \
                "<p>Click a button to close the message box. Pressing the Esc button " \
                "will activate the detected escape button (if any).")

 DirectQueryDlg::DirectQueryDlg(QWidget *parent)
     : QDialog(parent, Qt::Window)
 {	 
	backBtn		= new QPushButton(tr("ڷ"));
	applyBtn		= new QPushButton(tr(""));
	cancelBtn	= new QPushButton(tr(""));

	connect(backBtn, SIGNAL(clicked()), this, SLOT(clickBack()));
	connect(applyBtn, SIGNAL(clicked()), this, SLOT(clickApply()));
	connect(cancelBtn, SIGNAL(clicked()), this, SLOT(clickCancel()));

	//  ------------------------------
	this->textEdit = new MainTextEdit();
	new Highlighter(textEdit->GetTextEdit()->document());
	QHBoxLayout * textLayout = new QHBoxLayout;
	textLayout->addWidget(textEdit);
	// -----------------------------------

	QHBoxLayout * btnLayout = new QHBoxLayout;
	btnLayout->addWidget(backBtn);
	btnLayout->addWidget(applyBtn);
	btnLayout->addWidget(cancelBtn);
	btnLayout->setAlignment(Qt::AlignBottom | Qt::AlignRight);

    QVBoxLayout *queryBoxLayout = new QVBoxLayout;

	//  ------------------------------
	queryBoxLayout->addLayout(textLayout);
	queryBoxLayout->addLayout(btnLayout);
	setLayout(queryBoxLayout);

	setGeometry(100,100,800,800);

    setWindowTitle(tr(" ̺ "));

	//qDebug() << "modeSelect";
 }

 void DirectQueryDlg::clickBack()
 {
	 accept ();

	 IntroModeSelectDlg	*selectMode = new IntroModeSelectDlg();
	 selectMode->exec();
 }

//  -----------------------------------
 void DirectQueryDlg::clickApply()
 {
	QString buffer = this->textEdit->GetTextEdit()->toPlainText();
	ConnectionForm::getInstance()->GetMainForm()->ExcuteQeury(buffer);
	this->close();
 }

 void DirectQueryDlg::clickCancel()
 {
	 QMessageBox::StandardButton closeMessage;
     closeMessage = QMessageBox::warning(this, tr(""),
         tr("̺ ⸦ մϴ.\n"
            " Ͻðڽϱ?"),
         QMessageBox::Yes | QMessageBox::No);

     if (closeMessage == QMessageBox::Yes)
         reject();
 }
